/** This class provides a GUI: a window with several int fields, 
   double fields, and text fields. The current version has 3 int fields, 
   0 double fields, and 3 String fields. <br><br>
   
   Whenever the button in the window is pressed, method buttonPressed 
   is called. The values are read from the integer fields, the assignment
   statements are executed, and the new values of x, y, and z are
   displayed. The current version adds 4 to the value stored in x.<br><br>
   
   Place code in method buttonPressed to change the values of
   int variables x, y, and z.
*/

/** IMPORTANT NOTE:

   The comments in this program are excessive!  As this is probably the
   first time you have seen a working Java program, we have tried to
   explain some of the more cryptic statements.  You DO NOT have to
   understand everything that happens in this program.  This lab is
   only to practice using assignment statements.
*/
   
   // These import statements allow the program to use the code in 
   // the associated packages. Packages will be covered in a later
   // lesson.
   import java.awt.*;
   import java.text.*;
   import java.util.*;

/** Since MyJLiveWindow extends JLiveWindow, it inherits the
   variables and methods of class JLiveWindow.
*/ 
public class MyJLiveWindow extends JLiveWindow {
  
   /* Useful methods inherited from JLiveWindow: */
       
   // getIntField(i)     for the number in int    field i; 0 is first field
   // getdoubleField(i)  for the number in double field i; 0 is first field
   // getStringField(i)  for the number in String field i; 0 is first field
   // setIntField(i,v);     to store int value v in field i
   // setDoubleField(i,v);  to store double value v in field i
   // setStringField(i,v);   to store String value v in field i


   /** Process click of button titled "Ready!" */
       When the "Ready!" button is clicked, assign the current
       values in the int fields to their corresponding variables, and
       execute the assignment statement(s).
       (The identifier of each int variable is shown in the
       String field to the right of the int field.) */
   public Object buttonPressed() {
 
      int x= getIntField(0);  // read the value from the first int field
      int y= getIntField(1);  // second int field
      int z= getIntField(2);  // third int field
      
      /* Place your code here. */
      x= x+4;
      
      
      // Display changes to x, y, z in the JLiveWindow.
         print3(x, y, z);
      
      return null;
   }
   
 
   /** This is the main method, so the program starts execution here.
        Create an instance of me and show it. */
   public static void main(String args[]) {
   
      /* Create a new MyJLiveWindow object. */
      // The first argument to MyJLiveWindow is the number of int fields,
      // the second argument is the number of double fields, and
      // the third argument is the number of text (or String) fields.
      MyJLiveWindow testJLiveWindow= new MyJLiveWindow(3, 0, 3);
      
      // Set the String fields to display "x", "y", "z", respectively,
      // and then display the JLiveWindow.
      testJLiveWindow.resetStringFields();
      testJLiveWindow.showWindow();
      
      /* Now that the JLiveWindow is displayed, method buttonPressed will
         automatically be called when the user clicks on the "Ready!"
         button.
         
         The program quits when the user closes the JLiveWindow. (This
         is set in class JLiveWindow.)
      */
   }
   
   
   /** Whenever a MyJLiveWindow object is created (using the "new"
       keyword), this constructor (a special type of method)
       is called.
   */
   // Create my window with
   //    max( min(i,MAX_FIELDS), 0) integer fields,
   //    max( min(d,MAX_FIELDS), 0) double fields, and
   //    max( min(s,MAX_FIELDS), 0) String fields
   //    and a "ready" button
   public MyJLiveWindow(int i, int d, int s) {
      // "super" calls the constructor of the superclass - JLiveWindow
      super(i, d, s);
   }

   
   /** Place the int values x, y, z in the 0, 1, 2 int fields.
       Reset the value in the the String fields to "x", "y", "z". */
   public void print3(int x, int y, int z) {

      /* Note: the "try" and "catch" statements are for "thrown"
         objects.  You don't need to worry about them now, but
         they are needed here or the code will generate errors and
         will not compile.
      */
      try {
          setIntField(0, x);
      } catch (IllegalArgumentException iae) {}
      
      try {
          setIntField(1, y);
      } catch (IllegalArgumentException iae) {}
      
      try {
          setIntField(2, z);
      } catch (IllegalArgumentException iae) {}
   
      // "this" is a reference to the current instance of MyJLiveWindow
      this.resetStringFields();
   }
   
   
   /** Reset the value in the the String fields to " x", " y", " z". */
   public void resetStringFields() {

      /* Note: the "try" and "catch" statements are for "thrown"
         objects.  You don't need to worry about them now, but
         they are needed here or the code will generate errors and
         will not compile.
      */
      try {
          setStringField(0, " x");
      } catch (IllegalArgumentException iae) {}
      
      try {
          setStringField(1, " y");
      } catch (IllegalArgumentException iae) {}
      
      try {
          setStringField(2, " z");
      } catch (IllegalArgumentException iae) {}
   }  
}

